# 帳票設計書 20-Job Artifacts Report

## 概要

本ドキュメントは、GitLabにおけるJob Artifacts Report機能の帳票設計書である。ジョブアーティファクトの追跡レポートを生成する機能について、データ構造、処理フローを定義する。

### 本帳票の処理概要

Job Artifacts Reportは、CIパイプラインで生成されたジョブアーティファクトの利用状況を追跡するレポートである。テストレポートやカバレッジレポートなど、特定タイプのアーティファクトがアップロードされた際にユーザー単位で利用イベントを記録する。

**業務上の目的・背景**：CI/CD機能の利用状況を把握し、製品改善やリソース計画に活用する。このレポートにより、テストレポートやカバレッジレポートのアップロード頻度を追跡し、機能の採用状況を定量的に測定できる。プロダクト分析やユーザー行動分析に重要なデータを提供する。

**帳票の利用シーン**：製品チームがCI機能の利用状況を分析する場合、ユーザー行動の追跡データを収集する場合、機能採用のKPIを測定する場合などで利用される。

**主要な出力内容**：
1. イベント名（i_testing_test_report_uploaded / i_testing_coverage_report_uploaded）
2. ユーザーID
3. パイプライン完了フラグ

**帳票の出力タイミング**：パイプライン完了後にサービスが呼び出され、特定タイプのアーティファクトが存在する場合に利用イベントを記録する。

**帳票の利用者**：製品分析チーム、プロダクトマネージャー（内部利用）

## 帳票種別

JSON出力（内部イベントトラッキング）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | N/A | - | パイプライン完了時に自動実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 内部イベント（usage_data） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | track_usage_event API |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

イベントデータ構造

```ruby
# テストレポートアップロードイベント
{
  event_name: "i_testing_test_report_uploaded",
  user_id: 123
}

# カバレッジレポートアップロードイベント
{
  event_name: "i_testing_coverage_report_uploaded",
  user_id: 123
}
```

### ヘッダー部

N/A

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | event_name | イベント名 | event_name(report) | 文字列 |
| 2 | user_id | ユーザーID | pipeline.user_id | 数値 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パイプライン完了 | pipeline.complete? | Yes |
| レポート存在 | complete_and_has_reports? | Yes |

### ソート順

N/A

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ci_pipelines | パイプライン情報 | 主テーブル |
| ci_job_artifacts | ジョブアーティファクト | 存在チェック |

### テーブル別参照項目詳細

#### ci_pipelines

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| user_id | user_id | - | イベント記録対象ユーザー |

#### ci_job_artifacts

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| file_type | - | :test または :coverage | レポートタイプ判定 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | - | - | 計算項目なし |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[パイプライン完了] --> B[TrackArtifactReportService#execute]
    B --> C{REPORT_TRACKED ループ}
    C --> D[complete_and_has_reports? チェック]
    D -->|レポート有り| E[track_usage_event 呼び出し]
    D -->|レポート無し| F[スキップ]
    E --> G[次のレポートタイプ]
    F --> G
    G --> C
    C -->|ループ終了| H[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 該当なし | - | - | エラー処理なし（ログのみ） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | REPORT_TRACKED配列のサイズ（2） |
| 目標出力時間 | 100ms以内 |
| 同時出力数上限 | パイプライン完了イベント単位 |

## セキュリティ考慮事項

- ユーザーIDのみを記録し、個人識別情報は含まない
- 内部イベントとして記録され、外部には公開されない

## 備考

- REPORT_TRACKED = [:test, :coverage] で追跡対象を定義
- Gitlab::Utils::UsageDataモジュールのtrack_usage_eventを使用
- 製品分析・テレメトリ用途で使用

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

追跡対象のレポートタイプを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | track_artifact_report_service.rb | `app/services/ci/job_artifacts/track_artifact_report_service.rb` | REPORT_TRACKED定数でtestとcoverageを定義 |

**読解のコツ**: REPORT_TRACKED配列で追跡対象を限定。各タイプに対してイベントを記録。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | track_artifact_report_service.rb | `app/services/ci/job_artifacts/track_artifact_report_service.rb` | メインサービス。execute()がエントリーポイント |

**主要処理フロー**:
1. **8行目**: REPORT_TRACKED = %i[test coverage] - 追跡対象の定義
2. **10-15行目**: executeメソッド - 各レポートタイプをループ処理
3. **12-13行目**: complete_and_has_reports?チェックとtrack_usage_event呼び出し
4. **17-19行目**: event_nameメソッド - イベント名の生成（i_testing_{report}_report_uploaded）

#### Step 3: UsageDataモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | usage_data.rb | `lib/gitlab/utils/usage_data.rb` | track_usage_eventメソッドの実装 |

**主要処理フロー**:
- track_usage_event(event_name, user_id) - RedisHLLにイベントを記録

### プログラム呼び出し階層図

```
Ci::JobArtifacts::TrackArtifactReportService#execute
    │
    ├─ REPORT_TRACKED.each do |report| (:test, :coverage)
    │      │
    │      ├─ pipeline.complete_and_has_reports?(Ci::JobArtifact.of_report_type(report))
    │      │      └─ アーティファクト存在チェック
    │      │
    │      └─ track_usage_event(event_name(report), pipeline.user_id)
    │             │
    │             ├─ event_name(:test) → "i_testing_test_report_uploaded"
    │             └─ event_name(:coverage) → "i_testing_coverage_report_uploaded"
    │
    └─ Gitlab::Utils::UsageData#track_usage_event
           └─ RedisHLLにイベント記録
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ci_pipelines ─────────────▶ TrackArtifactReportService
(complete?)                        │
                                   ├─ complete_and_has_reports?
ci_job_artifacts ─────────▶        │      └─ of_report_type(:test/:coverage)
(file_type)                        │
                                   └─ track_usage_event
                                          │
                                          ├─ event_name
                                          │      └─ "i_testing_{report}_report_uploaded"
                                          │
                                          └─ user_id
                                                 └─ pipeline.user_id
                                                        ↓
                                                 RedisHLL / Usage Data
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| track_artifact_report_service.rb | `app/services/ci/job_artifacts/track_artifact_report_service.rb` | ソース | メインサービス |
| usage_data.rb | `lib/gitlab/utils/usage_data.rb` | ソース | UsageDataモジュール |
| pipeline.rb | `app/models/ci/pipeline.rb` | ソース | complete_and_has_reports?メソッド |
| job_artifact.rb | `app/models/ci/job_artifact.rb` | ソース | of_report_typeスコープ |
